#version 330

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 NormalMatrix;

layout (location = 0) in vec3 vert_Position;
layout (location = 1) in vec2 vert_TexCoord;
layout (location = 2) in vec3 vert_Normal;

out vec2 TexCoord;
out vec3 Normal;

void main()
{
	TexCoord = vert_TexCoord;
	Normal = (NormalMatrix * vec4(vert_Normal, 0.0)).xyz;
	gl_Position = ProjectionMatrix * (ModelViewMatrix * vec4(vert_Position, 1.0));
}
